// This file was generated Sat Nov 05 20:23:41 2016


// Declaration of all drivers
#define DRV extern struct BurnDriver
DRV	BurnDrvAbcop;
DRV	BurnDrvAceattac;
DRV	BurnDrvAceattaca;
DRV	BurnDrvAFighter;
DRV	BurnDrvAburner;
DRV	BurnDrvAburner2;
DRV	BurnDrvAlexkidd1;
DRV	BurnDrvAlexkidd;
DRV	BurnDrvAstormj;
DRV	BurnDrvAstormu;
DRV	BurnDrvAstorm3;
DRV	BurnDrvAstorm;
DRV	BurnDrvAstormja;
DRV	BurnDrvAliensynjo;
DRV	BurnDrvAliensyn2;
DRV	BurnDrvAliensyn3;
DRV	BurnDrvAliensyn;
DRV	BurnDrvAliensyn5;
DRV	BurnDrvAliensynj;
DRV	BurnDrvAltbeast2;
DRV	BurnDrvAltbeast4;
DRV	BurnDrvAltbeast5;
DRV	BurnDrvAltbeast;
DRV	BurnDrvAtomicp;
DRV	BurnDrvAurailj;
DRV	BurnDrvAurail1;
DRV	BurnDrvAurail;
DRV	BurnDrvBayroute1;   		// No Sound, Missing Z80 Program ROM
DRV	BurnDrvBayroutej;
DRV	BurnDrvBayroute;
DRV	BurnDrvBloxeed;
DRV	BurnDrvBlox16b;
DRV	BurnDrvBodyslam;
//DRV	BurnDrvBullet;
DRV	BurnDrvCltchitrj;
DRV	BurnDrvCltchitr;
DRV	BurnDrvCottonj;
DRV	BurnDrvCottonu;
DRV	BurnDrvCotton;
DRV	BurnDrvDdcrew1;
DRV	BurnDrvDdcrew2;
DRV	BurnDrvDdcrewu;
DRV	BurnDrvDdcrew;
DRV	BurnDrvDdcrewj;
DRV	BurnDrvDefense;
DRV	BurnDrvDesertbrj;
DRV	BurnDrvDesertbr;
DRV	BurnDrvDumpmtmt;
DRV	BurnDrvDunkshot;
DRV	BurnDrvDduxbl;
DRV	BurnDrvDdux1;
DRV	BurnDrvDdux;
DRV	BurnDrvEswatbl;
DRV	BurnDrvEswatj;
DRV	BurnDrvEswatu;
DRV	BurnDrvEswat;
DRV	BurnDrvEnduror;
DRV	BurnDrvEnduror1;
DRV	BurnDrvEndurobl;
DRV	BurnDrvExctleag;
DRV	BurnDrvFantzonep;   		// No sound - encrypted Z80
DRV	BurnDrvFantzone;
DRV	BurnDrvFantzoneta;
DRV	BurnDrvFantzone1;
DRV	BurnDrvFantzn2x;
DRV	BurnDrvFantznta;
DRV	BurnDrvFpointbj;
DRV	BurnDrvFpointbl;
DRV	BurnDrvFpoint1;
DRV	BurnDrvFpoint;
DRV	BurnDrvGloc;
DRV	BurnDrvGlocr360;
DRV	BurnDrvGprider1;
DRV	BurnDrvGprider;
DRV	BurnDrvGforce2;
DRV	BurnDrvGforce2j;
DRV	BurnDrvGforce2ja;
DRV	BurnDrvGoldnaxe1;
DRV	BurnDrvGoldnaxe2;
DRV	BurnDrvGoldnaxe3;
DRV	BurnDrvGoldnaxej;
DRV	BurnDrvGoldnaxeu;
DRV	BurnDrvGoldnaxe;
DRV	BurnDrvHamaway;
DRV	BurnDrvHangon1;
DRV	BurnDrvHangon;
DRV	BurnDrvHwchamp;
DRV	BurnDrvHwchampj;
DRV	BurnDrvIsgsm;   		// BIOS only
DRV	BurnDrvAltbeastj3;
DRV	BurnDrvAltbeastj;
DRV	BurnDrvLghostu;
DRV	BurnDrvLghost;
DRV	BurnDrvLastsurv;
DRV	BurnDrvShangonle;
DRV BurnDrvLockonph;
DRV	BurnDrvLoffirej;
DRV	BurnDrvLoffireu;
DRV	BurnDrvLoffire;
DRV	BurnDrvMvpj;
DRV	BurnDrvMvp;
DRV	BurnDrvMjleague;
DRV	BurnDrvMWalkbl;
DRV	BurnDrvMWalk;
DRV	BurnDrvOutrunb;
DRV	BurnDrvOutrundx;
DRV	BurnDrvOutruno;
DRV	BurnDrvOutrunra;
DRV	BurnDrvOutrun;
DRV	BurnDrvPassshtj;
DRV	BurnDrvPasssht16a;
DRV	BurnDrvPasssht;
DRV	BurnDrvPassshta;
#if defined FBA_DEBUG
DRV	BurnDrvPassshtb;
#endif
DRV	BurnDrvPdriftj;
DRV	BurnDrvPdrifta;
DRV	BurnDrvPdrifte;
DRV	BurnDrvPdrift;
DRV	BurnDrvQuarteta;
DRV	BurnDrvQuartet;
DRV	BurnDrvQuartet2;
DRV	BurnDrvQuartet2a;
DRV	BurnDrvRachero;
DRV	BurnDrvRchasej;
DRV	BurnDrvRchase;
DRV	BurnDrvRiotcity;
#if defined FBA_DEBUG
DRV	BurnDrvRascot2;
#endif
DRV	BurnDrvRyukyu;
DRV	BurnDrvSdi;
DRV	BurnDrvSdib;
DRV	BurnDrvSdibl;
#if defined FBA_DEBUG
DRV	BurnDrvShdancbl;
#endif
DRV	BurnDrvShdancer1;
DRV	BurnDrvShdancerj;
DRV	BurnDrvShdancer;
DRV	BurnDrvShinobls;
DRV	BurnDrvShinoblb;
DRV	BurnDrvShinobi1;
DRV	BurnDrvShinobi2;
DRV	BurnDrvShinobi3;
DRV	BurnDrvShinobi4;
DRV	BurnDrvShinobi5;
DRV	BurnDrvShinobi;
DRV	BurnDrvShinfz;
DRV	BurnDrvSnapper;
DRV	BurnDrvSonicbom;
DRV	BurnDrvSharrier1;
DRV	BurnDrvSharrier;
DRV	BurnDrvStrkfgtr;
DRV	BurnDrvSjryuko1;
DRV	BurnDrvSjryuko;
#if defined FBA_DEBUG
DRV	BurnDrvShangonro;
DRV	BurnDrvShangonrb;
#endif
DRV	BurnDrvShangon2;
DRV	BurnDrvShangon3;
DRV	BurnDrvShangon;
DRV	BurnDrvSuprleag;
DRV	BurnDrvSmgpja;
DRV	BurnDrvSmgpj;
DRV	BurnDrvSmgpu2;
DRV	BurnDrvSmgpu1;
DRV	BurnDrvSmgpu;
DRV	BurnDrvSmgp5;
DRV	BurnDrvSmgp6;
DRV	BurnDrvSmgp;
DRV	BurnDrvSmgpu3;
DRV	BurnDrvTetrisbl;
DRV	BurnDrvTetris1;
DRV	BurnDrvTetris2;
DRV	BurnDrvTetris3;
DRV	BurnDrvTetris;
DRV	BurnDrvTetrbx;
DRV	BurnDrvThndrbld1;
DRV	BurnDrvThndrbld;
DRV	BurnDrvTimescan1;
DRV	BurnDrvTimescan;
DRV	BurnDrvToryumon;
DRV	BurnDrvTturfu;
DRV	BurnDrvTturf;   		// No Sound, Missing Z80 Program
DRV	BurnDrvToutrun;
#if defined FBA_DEBUG
DRV	BurnDrvToutrun2;
#endif
DRV	BurnDrvToutrun1;
DRV	BurnDrvToutrun3;
DRV	BurnDrvWwallyja;
DRV	BurnDrvWwallyj;
#if defined FBA_DEBUG
DRV	BurnDrvWb3bbl;
#endif
DRV	BurnDrvWb31;
DRV	BurnDrvWb32;
DRV	BurnDrvWb33;
DRV	BurnDrvWb34;
DRV	BurnDrvWb3;
DRV	BurnDrvWrestwar1;
DRV	BurnDrvWrestwar2;
DRV	BurnDrvWrestwar;
#undef DRV

// Structure containing addresses of all drivers
// Needs to be kept sorted (using the full game name as the key) to prevent problems with the gamelist in Kaillera
static struct BurnDriver* pDriver[] = {
	&BurnDrvAbcop,			// A.B. Cop (FD1094 317-0169b)
	&BurnDrvAceattac,		// Ace Attacker (FD1094 317-0059)
	&BurnDrvAceattaca,		// Ace Attacker (Japan, System 16A, FD1094 317-0060)
	&BurnDrvAFighter,		// Action Fighter, FD1089A 317-0018
	&BurnDrvAburner,		// After Burner (Japan)
	&BurnDrvAburner2,		// After Burner II
	&BurnDrvAlexkidd1,		// Alex Kidd: The Lost Stars (set 1, FD1089A 317-unknown)
	&BurnDrvAlexkidd,		// Alex Kidd: The Lost Stars (set 2, unprotected)
	&BurnDrvAstormj,		// Alien Storm (set 1, Japan, 2 Players, FD1094 317-0146)
	&BurnDrvAstormu,		// Alien Storm (set 2, US, 3 Players, FD1094 317-0147)
	&BurnDrvAstorm3,		// Alien Storm (set 3, World, 3 Players, FD1094 317-0148)
	&BurnDrvAstorm,			// Alien Storm (set 4, World, 2 Players, FD1094 317-0154)
	&BurnDrvAstormja,		// Alien Storm (set 5, Japan Rev B, 2 Players, FD1094 317-0146)
	&BurnDrvAliensynjo,		// Alien Syndrome (set 1, Japan, old, System 16A, FD1089A 317-0033)
	&BurnDrvAliensyn2,		// Alien Syndrome (set 2, System 16A, FD1089A 317-0033)
	&BurnDrvAliensyn3,		// Alien Syndrome (set 3, System 16B, FD1089A 317-0033)
	&BurnDrvAliensyn,		// Alien Syndrome (set 4, System 16B, unprotected)
	&BurnDrvAliensyn5,		// Alien Syndrome (set 5, System 16A, FD1089B 317-0037)
	&BurnDrvAliensynj,		// Alien Syndrome (set 6, Japan, new, System 16B, FD1089A 317-0033)
	&BurnDrvAltbeast2,		// Altered Beast (set 2, MC-8123B 317-0066)
	&BurnDrvAltbeast4,		// Altered Beast (set 4, MC-8123B 317-0066)
	&BurnDrvAltbeast5,		// Altered Beast (set 5, 8751 317-0076)
	&BurnDrvAltbeast,		// Altered Beast (set 7, 8751 317-0078)
	&BurnDrvAtomicp,		// Atomic Point (Korea)
	&BurnDrvAurailj,		// Aurail (set 1, Japan, FD1089A 317-0167)
	&BurnDrvAurail1,		// Aurail (set 2, World, FD1089B 317-0168)
	&BurnDrvAurail,			// Aurail (set 3, US, unprotected)
	&BurnDrvBayroute1,		// Bay Route (set 1, US, unprotected)
	&BurnDrvBayroutej,		// Bay Route (set 2, Japan, FD1094 317-0115)
	&BurnDrvBayroute,		// Bay Route (set 3, World, FD1094 317-0116)
	&BurnDrvBloxeed,		// Bloxeed (Japan, FD1094 317-0139)
	&BurnDrvBlox16b,		// Bloxeed (System 16B, PS2 data file)
	&BurnDrvBodyslam,		// Body Slam (8751 317-0015)
	//&BurnDrvBullet,			// Bullet (FD1094 317-0041)
	&BurnDrvCltchitrj,		// Clutch Hitter (set 1, Japan, FD1094 317-0175)
	&BurnDrvCltchitr,		// Clutch Hitter (set 2, US, FD1094 317-0176)
	&BurnDrvCottonj,		// Cotton (set 1, Japan, FD1094 317-0179a))
	&BurnDrvCottonu,		// Cotton (set 2, US, FD1094 317-0180)
	&BurnDrvCotton,			// Cotton (set 3, World, FD1094 317-0181a)
	&BurnDrvDdcrew1,		// D. D. Crew (set 1, World, 4 Player, FD1094 317-?)
	&BurnDrvDdcrew2,		// D. D. Crew (set 2, World, 2 Player, FD1094 317-0184)
	&BurnDrvDdcrewu,		// D. D. Crew (set 3, US, 4 Player, FD1094 317-0186)
	&BurnDrvDdcrew,			// D. D. Crew (set 4, World, 3 Player, FD1094 317-0190)
	&BurnDrvDdcrewj,		// D. D. Crew (set 5, Japan, 2 Player, FD1094 317-0182)
	&BurnDrvDefense,		// Defense (System 16B, FD1089A 317-0028)
	&BurnDrvDesertbrj,		// Desert Breaker (Japan, FD1094 317-0194)
	&BurnDrvDesertbr,		// Desert Breaker (World, FD1094 317-0196)
	&BurnDrvDumpmtmt,		// Dump Matsumoto (Japan, 8751 317-unknown)
	&BurnDrvDunkshot,		// Dunk Shot (FD1089 317-0022)
	&BurnDrvDduxbl,			// Dynamite Dux (bootleg)
	&BurnDrvDdux1,			// Dynamite Dux (set 1, 8751 317-0095)
	&BurnDrvDdux,			// Dynamite Dux (set 2, FD1094 317-0096)
	&BurnDrvEswatbl,		// E-Swat - Cyber Police (bootleg)
	&BurnDrvEswatj,			// E-Swat - Cyber Police (set 1, Japan, FD1094 317-0128)
	&BurnDrvEswatu,			// E-Swat - Cyber Police (set 2, US, FD1094 317-0129)
	&BurnDrvEswat,			// E-Swat - Cyber Police (set 3, World, FD1094 317-0130)
	&BurnDrvEnduror,		// Enduro Racer (YM2151, FD1089B 317-0013A)
	&BurnDrvEnduror1,		// Enduro Racer (YM2203, FD1089B 317-0013A)
	&BurnDrvEndurobl,		// Enduro Racer (bootleg set 1)
	&BurnDrvExctleag,		// Excite League (FD1094 317-0079)
	&BurnDrvFantzonep,		// Fantasy Zone (317-5000)
	&BurnDrvFantzone,		// Fantasy Zone (Rev A, unprotected)
	&BurnDrvFantzoneta,		// Fantasy Zone (Time Attack, bootleg)
	&BurnDrvFantzone1,		// Fantasy Zone (unprotected)
	&BurnDrvFantzn2x,		// Fantasy Zone 2 (System 16C version, PS2 data file)
	&BurnDrvFantznta,		// Fantasy Zone Time Attack (System 16B, PS2 data file)
	&BurnDrvFpointbj,		// Flash Point (Japan, bootleg)
	&BurnDrvFpointbl,		// Flash Point (World, bootleg)
	&BurnDrvFpoint1,		// Flash Point (set 1, Japan, FD1094 317-0127A)
	&BurnDrvFpoint,			// Flash Point (set 2, Japan, FD1094 317-0127A)
	&BurnDrvGloc,			// G-LOC Air Battle (US)
	&BurnDrvGlocr360,		// G-LOC R360
	&BurnDrvGprider1,		// GP Rider (set 1, US, FD1094 317-0162)
	&BurnDrvGprider,		// GP Rider (set 2, World, FD1094 317-0163)
	&BurnDrvGforce2,		// Galaxy Force 2
	&BurnDrvGforce2j,		// Galaxy Force 2 (Japan)
	&BurnDrvGforce2ja,		// Galaxy Force 2 (Japan, Rev A)
	&BurnDrvGoldnaxe1,		// Golden Axe (set 1, World, FD1094 317-0110)
	&BurnDrvGoldnaxe2,		// Golden Axe (set 2, US, 8751 317-0112)
	&BurnDrvGoldnaxe3,		// Golden Axe (set 3, World, FD1094 317-0120)
	&BurnDrvGoldnaxej,		// Golden Axe (set 4, Japan, FD1094 317-0121)
	&BurnDrvGoldnaxeu,		// Golden Axe (set 5, US, FD1094 317-0122)
	&BurnDrvGoldnaxe,		// Golden Axe (set 6, US, 8751 317-123A)
	&BurnDrvHamaway,		// Hammer Away (prototype)
	&BurnDrvHangon1,		// Hang-On
	&BurnDrvHangon,			// Hang-On (rev A)
	&BurnDrvHwchamp,		// Heavyweight Champ
	&BurnDrvHwchampj,		// Heavyweight Champ (Japan, FD1094 317-0046)
	&BurnDrvIsgsm,			// ISG Selection Master Type 2006 System BIOS
	&BurnDrvAltbeastj3,		// Juuouki (set 3, Japan, FD1094 317-0068)
	&BurnDrvAltbeastj,		// Juuouki (set 6, Japan, 8751 317-0077)
	&BurnDrvLghostu,		// Laser Ghost (set 1, US, 317-0165)
	&BurnDrvLghost,			// Laser Ghost (set 2, World, 317-0166)
	&BurnDrvLastsurv,		// Last Survivor (FD1094 317-0083)
	&BurnDrvShangonle,		// Limited Edition Hang-On
	&BurnDrvLoffirej,		// Line of Fire / Bakudan Yarou (Japan, FD1094 317-0134)
	&BurnDrvLoffireu,		// Line of Fire / Bakudan Yarou (US, FD1094 317-0135)
	&BurnDrvLoffire,		// Line of Fire / Bakudan Yarou (World, FD1094 317-0136)
	&BurnDrvLockonph,		// Lock On (Philko)
	&BurnDrvMvpj,			// MVP (set 1, Japan, FD1094 317-0142)
	&BurnDrvMvp,			// MVP (set 2, US, FD1094 317-0143)
	&BurnDrvMjleague,		// Major League
	&BurnDrvMWalkbl,		// Michael Jackson's Moonwalker (bootleg)
	&BurnDrvMWalk,			// Michael Jackson's Moonwalker (set 3, World, FD1094/8751 317-0159)
	&BurnDrvOutrunb,		// Out Run (bootleg)
	&BurnDrvOutrundx,		// Out Run (deluxe sitdown)
	&BurnDrvOutruno,		// Out Run (sitdown/upright)
	&BurnDrvOutrunra,		// Out Run (sitdown/upright, Rev A)
	&BurnDrvOutrun,			// Out Run (sitdown/upright, Rev B)
	&BurnDrvPassshtj,		// Passing Shot (Japan, 4 Players, FD1094 317-0070)
	&BurnDrvPasssht16a,		// Passing Shot (Japan, 4 Players, System 16A, FD1094 317-0071)
	&BurnDrvPasssht,		// Passing Shot (World, 2 Players, FD1094 317-0080)
	&BurnDrvPassshta,		// Passing Shot (World, 4 Players, FD1094 317-0074)
#if defined FBA_DEBUG
	&BurnDrvPassshtb,		// Passing Shot (bootleg, 2 Players)
#endif
	&BurnDrvPdriftj,		// Power Drift (Japan)
	&BurnDrvPdrifta,		// Power Drift (World)
	&BurnDrvPdrifte,		// Power Drift (World, Earlier)
	&BurnDrvPdrift,			// Power Drift (World, Rev A)
	&BurnDrvQuarteta,		// Quartet (8751 315-5194)
	&BurnDrvQuartet,		// Quartet (Rev A, 8751 317-unknown)
	&BurnDrvQuartet2,		// Quartet 2 (8751 317-0010)
	&BurnDrvQuartet2a,		// Quartet 2 (unprotected)
	&BurnDrvRachero,		// Racing Hero (FD1094 317-0144)
	&BurnDrvRchasej,		// Rail Chase (Japan)
	&BurnDrvRchase,			// Rail Chase (World)
	&BurnDrvRiotcity,		// Riot City (Japan)
#if defined FBA_DEBUG
	&BurnDrvRascot2,		// Royal Ascot 2
#endif
	&BurnDrvRyukyu,			// RyuKyu (Japan, FD1094 317-5023)
	&BurnDrvSdi,			// SDI - Strategic Defense Initiative (Japan, old, System 16A, FD1089B 317-0027)
	&BurnDrvSdib,			// SDI - Strategic Defense Initiative (System 16B, FD1089A 317-0028)
	&BurnDrvSdibl,			// SDI - Strategic Defense Initiative (bootleg)
#if defined FBA_DEBUG
	&BurnDrvShdancbl,		// Shadow Dancer (bootleg)
#endif
	&BurnDrvShdancer1,		// Shadow Dancer (set 1)
	&BurnDrvShdancerj,		// Shadow Dancer (set 2, Japan)
	&BurnDrvShdancer,		// Shadow Dancer (set 3, US)
	&BurnDrvShinobls,		// Shinobi (Star bootleg, System 16A)
	&BurnDrvShinoblb,		// Shinobi (beta bootleg, System 16A)
	&BurnDrvShinobi1,		// Shinobi (set 1, System 16A, FD1094 317-0050)
	&BurnDrvShinobi2,		// Shinobi (set 2, System 16B, FD1094 317-0049)
	&BurnDrvShinobi3,		// Shinobi (set 3, System 16B, MC-8123B 317-0054)
	&BurnDrvShinobi4,		// Shinobi (set 4, System 16B, MC-8123B 317-0054)
	&BurnDrvShinobi5,		// Shinobi (set 5, System 16B, unprotected)
	&BurnDrvShinobi,		// Shinobi (set 6, System 16A, unprotected)
	&BurnDrvShinfz,			// Shinobi / FZ-2006 (Korean System 16 bootleg) (ISG Selection Master Type 2006)
	&BurnDrvSnapper,		// Snapper (Korea)
	&BurnDrvSonicbom,		// Sonic Boom (FD1094 317-0053)
	&BurnDrvSharrier1,		// Space Harrier (8751 315-5163)
	&BurnDrvSharrier,		// Space Harrier (Rev A, 8751 315-5163A)
	&BurnDrvStrkfgtr,		// Strike Fighter (Japan)
	&BurnDrvSjryuko1,		// Sukeban Jansi Ryuko (set 1, System 16A, FD1089B 317-5021)
	&BurnDrvSjryuko,		// Sukeban Jansi Ryuko (set 2, System 16B, FD1089B 317-5021)
#if defined FBA_DEBUG
	&BurnDrvShangonro,		// Super Hang-On (Japan, FD1094 317-0038)
	&BurnDrvShangonrb,		// Super Hang-On (bootleg)
#endif
	&BurnDrvShangon2,		// Super Hang-On (mini ride-on, Rev A, FD1089B 317-0034)
	&BurnDrvShangon3,		// Super Hang-On (sitdown/upright, FD1089B 317-0034)
	&BurnDrvShangon,		// Super Hang-On (sitdown/upright, unprotected)
	&BurnDrvSuprleag,		// Super League (FD1094 317-0045)
	&BurnDrvSmgpja,			// Super Monaco GP (Japan, Rev A, FD1094 317-0124a)
	&BurnDrvSmgpj,			// Super Monaco GP (Japan, Rev B, FD1094 317-0124a)
	&BurnDrvSmgpu2,			// Super Monaco GP (US, Rev A, FD1094 317-0125a)
	&BurnDrvSmgpu1,			// Super Monaco GP (US, Rev B, FD1094 317-0125a)
	&BurnDrvSmgpu,			// Super Monaco GP (US, Rev C, FD1094 317-0125a)
	&BurnDrvSmgp5,			// Super Monaco GP (World, 'Air Drive Cabinet', FD1094 317-0126)
	&BurnDrvSmgp6,			// Super Monaco GP (World, Rev A, FD1094 317-0126a)
	&BurnDrvSmgp,			// Super Monaco GP (World, Rev B, 'Twin', FD1094 317-0126a)
	&BurnDrvSmgpu3,			// Super Monaco GP (set 3, US, FD1094 317-0125a)
	&BurnDrvTetrisbl,		// Tetris (bootleg)
	&BurnDrvTetris1,		// Tetris (set 1, Japan, System 16B, FD1094 317-0091)
	&BurnDrvTetris2,		// Tetris (set 2, Japan, System 16B, FD1094 317-0092)
	&BurnDrvTetris3,		// Tetris (set 3, Japan, System 16A, FD1094 317-0093a)
	&BurnDrvTetris,			// Tetris (set 4, Japan, System 16A, FD1094 317-0093)
	&BurnDrvTetrbx,			// Tetris / Bloxeed (Korean System 16 bootleg) (ISG Selection Master Type 2006)
	&BurnDrvThndrbld1,		// Thunder Blade (deluxe/standing, unprotected)
	&BurnDrvThndrbld,		// Thunder Blade (upright, FD1094 317-0056)
	&BurnDrvTimescan1,		// Time Scanner (set 1, System 16A, FD1089B 317-0024)
	&BurnDrvTimescan,		// Time Scanner (set 2, System 16B)
	&BurnDrvToryumon,		// Toryumon
	&BurnDrvTturfu,			// Tough Turf (set 1, US, 8751 317-0099)
	&BurnDrvTturf,			// Tough Turf (set 2, Japan, 8751 317-0104)
	&BurnDrvToutrun,		// Turbo Out Run (Out Run upgrade, FD1094 317-0118)
#if defined FBA_DEBUG
	&BurnDrvToutrun2,		// Turbo Out Run (cockpit, FD1094 317-unknown)
#endif
	&BurnDrvToutrun1,		// Turbo Out Run (deluxe cockpit, FD1094 317-0109)
	&BurnDrvToutrun3,		// Turbo Out Run (upright, FD1094 317-unknown)
	&BurnDrvWwallyja,		// Wally wo Sagase! (rev A, Japan, FD1094 317-0197A)
	&BurnDrvWwallyj,		// Wally wo Sagase! (rev B, Japan, FD1094 317-0197B)
#if defined FBA_DEBUG
	&BurnDrvWb3bbl,			// Wonder Boy III - Monster Lair (bootleg)
#endif
	&BurnDrvWb31,			// Wonder Boy III - Monster Lair (set 1, System 16A, FD1094 317-0084)
	&BurnDrvWb32,			// Wonder Boy III - Monster Lair (set 2, Japan, System 16B, FD1094 317-0085)
	&BurnDrvWb33,			// Wonder Boy III - Monster Lair (set 3, World, System 16B, FD1094 317-0089)
	&BurnDrvWb34,			// Wonder Boy III - Monster Lair (set 4, Japan, System 16B, FD1094 317-0087)
	&BurnDrvWb3,			// Wonder Boy III - Monster Lair (set 5, World, System 16B, 8751 317-0098)
	&BurnDrvWrestwar1,		// Wrestle War (set 1, Japan, FD1094 317-0090)
	&BurnDrvWrestwar2,		// Wrestle War (set 2, World, FD1094 317-0102)
	&BurnDrvWrestwar,		// Wrestle War (set 3, World, 8751 317-0103)
};

static struct BurnDriver* pAllDrivers[] = {
	&BurnDrvAbcop,			// A.B. Cop (FD1094 317-0169b)
	&BurnDrvAceattac,		// Ace Attacker (FD1094 317-0059)
	&BurnDrvAceattaca,		// Ace Attacker (Japan, System 16A, FD1094 317-0060)
	&BurnDrvAFighter,		// Action Fighter, FD1089A 317-0018
	&BurnDrvAburner,		// After Burner (Japan)
	&BurnDrvAburner2,		// After Burner II
	&BurnDrvAlexkidd1,		// Alex Kidd: The Lost Stars (set 1, FD1089A 317-unknown)
	&BurnDrvAlexkidd,		// Alex Kidd: The Lost Stars (set 2, unprotected)
	&BurnDrvAstormj,		// Alien Storm (set 1, Japan, 2 Players, FD1094 317-0146)
	&BurnDrvAstormu,		// Alien Storm (set 2, US, 3 Players, FD1094 317-0147)
	&BurnDrvAstorm3,		// Alien Storm (set 3, World, 3 Players, FD1094 317-0148)
	&BurnDrvAstorm,			// Alien Storm (set 4, World, 2 Players, FD1094 317-0154)
	&BurnDrvAstormja,		// Alien Storm (set 5, Japan Rev B, 2 Players, FD1094 317-0146)
	&BurnDrvAliensynjo,		// Alien Syndrome (set 1, Japan, old, System 16A, FD1089A 317-0033)
	&BurnDrvAliensyn2,		// Alien Syndrome (set 2, System 16A, FD1089A 317-0033)
	&BurnDrvAliensyn3,		// Alien Syndrome (set 3, System 16B, FD1089A 317-0033)
	&BurnDrvAliensyn,		// Alien Syndrome (set 4, System 16B, unprotected)
	&BurnDrvAliensyn5,		// Alien Syndrome (set 5, System 16A, FD1089B 317-0037)
	&BurnDrvAliensynj,		// Alien Syndrome (set 6, Japan, new, System 16B, FD1089A 317-0033)
	&BurnDrvAltbeast2,		// Altered Beast (set 2, MC-8123B 317-0066)
	&BurnDrvAltbeast4,		// Altered Beast (set 4, MC-8123B 317-0066)
	&BurnDrvAltbeast5,		// Altered Beast (set 5, 8751 317-0076)
	&BurnDrvAltbeast,		// Altered Beast (set 7, 8751 317-0078)
	&BurnDrvAtomicp,		// Atomic Point (Korea)
	&BurnDrvAurailj,		// Aurail (set 1, Japan, FD1089A 317-0167)
	&BurnDrvAurail1,		// Aurail (set 2, World, FD1089B 317-0168)
	&BurnDrvAurail,			// Aurail (set 3, US, unprotected)
	&BurnDrvBayroute1,		// Bay Route (set 1, US, unprotected)
	&BurnDrvBayroutej,		// Bay Route (set 2, Japan, FD1094 317-0115)
	&BurnDrvBayroute,		// Bay Route (set 3, World, FD1094 317-0116)
	&BurnDrvBloxeed,		// Bloxeed (Japan, FD1094 317-0139)
	&BurnDrvBlox16b,		// Bloxeed (System 16B, PS2 data file)
	&BurnDrvBodyslam,		// Body Slam (8751 317-0015)
	//&BurnDrvBullet,			// Bullet (FD1094 317-0041)
	&BurnDrvCltchitrj,		// Clutch Hitter (set 1, Japan, FD1094 317-0175)
	&BurnDrvCltchitr,		// Clutch Hitter (set 2, US, FD1094 317-0176)
	&BurnDrvCottonj,		// Cotton (set 1, Japan, FD1094 317-0179a))
	&BurnDrvCottonu,		// Cotton (set 2, US, FD1094 317-0180)
	&BurnDrvCotton,			// Cotton (set 3, World, FD1094 317-0181a)
	&BurnDrvDdcrew1,		// D. D. Crew (set 1, World, 4 Player, FD1094 317-?)
	&BurnDrvDdcrew2,		// D. D. Crew (set 2, World, 2 Player, FD1094 317-0184)
	&BurnDrvDdcrewu,		// D. D. Crew (set 3, US, 4 Player, FD1094 317-0186)
	&BurnDrvDdcrew,			// D. D. Crew (set 4, World, 3 Player, FD1094 317-0190)
	&BurnDrvDdcrewj,		// D. D. Crew (set 5, Japan, 2 Player, FD1094 317-0182)
	&BurnDrvDefense,		// Defense (System 16B, FD1089A 317-0028)
	&BurnDrvDesertbrj,		// Desert Breaker (Japan, FD1094 317-0194)
	&BurnDrvDesertbr,		// Desert Breaker (World, FD1094 317-0196)
	&BurnDrvDumpmtmt,		// Dump Matsumoto (Japan, 8751 317-unknown)
	&BurnDrvDunkshot,		// Dunk Shot (FD1089 317-0022)
	&BurnDrvDduxbl,			// Dynamite Dux (bootleg)
	&BurnDrvDdux1,			// Dynamite Dux (set 1, 8751 317-0095)
	&BurnDrvDdux,			// Dynamite Dux (set 2, FD1094 317-0096)
	&BurnDrvEswatbl,		// E-Swat - Cyber Police (bootleg)
	&BurnDrvEswatj,			// E-Swat - Cyber Police (set 1, Japan, FD1094 317-0128)
	&BurnDrvEswatu,			// E-Swat - Cyber Police (set 2, US, FD1094 317-0129)
	&BurnDrvEswat,			// E-Swat - Cyber Police (set 3, World, FD1094 317-0130)
	&BurnDrvEnduror,		// Enduro Racer (YM2151, FD1089B 317-0013A)
	&BurnDrvEnduror1,		// Enduro Racer (YM2203, FD1089B 317-0013A)
	&BurnDrvEndurobl,		// Enduro Racer (bootleg set 1)
	&BurnDrvExctleag,		// Excite League (FD1094 317-0079)
	&BurnDrvFantzonep,		// Fantasy Zone (317-5000)
	&BurnDrvFantzone,		// Fantasy Zone (Rev A, unprotected)
	&BurnDrvFantzoneta,		// Fantasy Zone (Time Attack, bootleg)
	&BurnDrvFantzone1,		// Fantasy Zone (unprotected)
	&BurnDrvFantzn2x,		// Fantasy Zone 2 (System 16C version, PS2 data file)
	&BurnDrvFantznta,		// Fantasy Zone Time Attack (System 16B, PS2 data file)
	&BurnDrvFpointbj,		// Flash Point (Japan, bootleg)
	&BurnDrvFpointbl,		// Flash Point (World, bootleg)
	&BurnDrvFpoint1,		// Flash Point (set 1, Japan, FD1094 317-0127A)
	&BurnDrvFpoint,			// Flash Point (set 2, Japan, FD1094 317-0127A)
	&BurnDrvGloc,			// G-LOC Air Battle (US)
	&BurnDrvGlocr360,		// G-LOC R360
	&BurnDrvGprider1,		// GP Rider (set 1, US, FD1094 317-0162)
	&BurnDrvGprider,		// GP Rider (set 2, World, FD1094 317-0163)
	&BurnDrvGforce2,		// Galaxy Force 2
	&BurnDrvGforce2j,		// Galaxy Force 2 (Japan)
	&BurnDrvGforce2ja,		// Galaxy Force 2 (Japan, Rev A)
	&BurnDrvGoldnaxe1,		// Golden Axe (set 1, World, FD1094 317-0110)
	&BurnDrvGoldnaxe2,		// Golden Axe (set 2, US, 8751 317-0112)
	&BurnDrvGoldnaxe3,		// Golden Axe (set 3, World, FD1094 317-0120)
	&BurnDrvGoldnaxej,		// Golden Axe (set 4, Japan, FD1094 317-0121)
	&BurnDrvGoldnaxeu,		// Golden Axe (set 5, US, FD1094 317-0122)
	&BurnDrvGoldnaxe,		// Golden Axe (set 6, US, 8751 317-123A)
	&BurnDrvHamaway,		// Hammer Away (prototype)
	&BurnDrvHangon1,		// Hang-On
	&BurnDrvHangon,			// Hang-On (rev A)
	&BurnDrvHwchamp,		// Heavyweight Champ
	&BurnDrvHwchampj,		// Heavyweight Champ (Japan, FD1094 317-0046)
	&BurnDrvIsgsm,			// ISG Selection Master Type 2006 System BIOS
	&BurnDrvAltbeastj3,		// Juuouki (set 3, Japan, FD1094 317-0068)
	&BurnDrvAltbeastj,		// Juuouki (set 6, Japan, 8751 317-0077)
	&BurnDrvLghostu,		// Laser Ghost (set 1, US, 317-0165)
	&BurnDrvLghost,			// Laser Ghost (set 2, World, 317-0166)
	&BurnDrvLastsurv,		// Last Survivor (FD1094 317-0083)
	&BurnDrvShangonle,		// Limited Edition Hang-On
	&BurnDrvLoffirej,		// Line of Fire / Bakudan Yarou (Japan, FD1094 317-0134)
	&BurnDrvLoffireu,		// Line of Fire / Bakudan Yarou (US, FD1094 317-0135)
	&BurnDrvLoffire,		// Line of Fire / Bakudan Yarou (World, FD1094 317-0136)
	&BurnDrvLockonph,		// Lock On (Philko)
	&BurnDrvMvpj,			// MVP (set 1, Japan, FD1094 317-0142)
	&BurnDrvMvp,			// MVP (set 2, US, FD1094 317-0143)
	&BurnDrvMjleague,		// Major League
	&BurnDrvMWalkbl,		// Michael Jackson's Moonwalker (bootleg)
	&BurnDrvMWalk,			// Michael Jackson's Moonwalker (set 3, World, FD1094/8751 317-0159)
	&BurnDrvOutrunb,		// Out Run (bootleg)
	&BurnDrvOutrundx,		// Out Run (deluxe sitdown)
	&BurnDrvOutruno,		// Out Run (sitdown/upright)
	&BurnDrvOutrunra,		// Out Run (sitdown/upright, Rev A)
	&BurnDrvOutrun,			// Out Run (sitdown/upright, Rev B)
	&BurnDrvPassshtj,		// Passing Shot (Japan, 4 Players, FD1094 317-0070)
	&BurnDrvPasssht16a,		// Passing Shot (Japan, 4 Players, System 16A, FD1094 317-0071)
	&BurnDrvPasssht,		// Passing Shot (World, 2 Players, FD1094 317-0080)
	&BurnDrvPassshta,		// Passing Shot (World, 4 Players, FD1094 317-0074)
#if defined FBA_DEBUG
	&BurnDrvPassshtb,		// Passing Shot (bootleg, 2 Players)
#endif
	&BurnDrvPdriftj,		// Power Drift (Japan)
	&BurnDrvPdrifta,		// Power Drift (World)
	&BurnDrvPdrifte,		// Power Drift (World, Earlier)
	&BurnDrvPdrift,			// Power Drift (World, Rev A)
	&BurnDrvQuarteta,		// Quartet (8751 315-5194)
	&BurnDrvQuartet,		// Quartet (Rev A, 8751 317-unknown)
	&BurnDrvQuartet2,		// Quartet 2 (8751 317-0010)
	&BurnDrvQuartet2a,		// Quartet 2 (unprotected)
	&BurnDrvRachero,		// Racing Hero (FD1094 317-0144)
	&BurnDrvRchasej,		// Rail Chase (Japan)
	&BurnDrvRchase,			// Rail Chase (World)
	&BurnDrvRiotcity,		// Riot City (Japan)
#if defined FBA_DEBUG
	&BurnDrvRascot2,		// Royal Ascot 2
#endif
	&BurnDrvRyukyu,			// RyuKyu (Japan, FD1094 317-5023)
	&BurnDrvSdi,			// SDI - Strategic Defense Initiative (Japan, old, System 16A, FD1089B 317-0027)
	&BurnDrvSdib,			// SDI - Strategic Defense Initiative (System 16B, FD1089A 317-0028)
	&BurnDrvSdibl,			// SDI - Strategic Defense Initiative (bootleg)
#if defined FBA_DEBUG
	&BurnDrvShdancbl,		// Shadow Dancer (bootleg)
#endif
	&BurnDrvShdancer1,		// Shadow Dancer (set 1)
	&BurnDrvShdancerj,		// Shadow Dancer (set 2, Japan)
	&BurnDrvShdancer,		// Shadow Dancer (set 3, US)
	&BurnDrvShinobls,		// Shinobi (Star bootleg, System 16A)
	&BurnDrvShinoblb,		// Shinobi (beta bootleg, System 16A)
	&BurnDrvShinobi1,		// Shinobi (set 1, System 16A, FD1094 317-0050)
	&BurnDrvShinobi2,		// Shinobi (set 2, System 16B, FD1094 317-0049)
	&BurnDrvShinobi3,		// Shinobi (set 3, System 16B, MC-8123B 317-0054)
	&BurnDrvShinobi4,		// Shinobi (set 4, System 16B, MC-8123B 317-0054)
	&BurnDrvShinobi5,		// Shinobi (set 5, System 16B, unprotected)
	&BurnDrvShinobi,		// Shinobi (set 6, System 16A, unprotected)
	&BurnDrvShinfz,			// Shinobi / FZ-2006 (Korean System 16 bootleg) (ISG Selection Master Type 2006)
	&BurnDrvSnapper,		// Snapper (Korea)
	&BurnDrvSonicbom,		// Sonic Boom (FD1094 317-0053)
	&BurnDrvSharrier1,		// Space Harrier (8751 315-5163)
	&BurnDrvSharrier,		// Space Harrier (Rev A, 8751 315-5163A)
	&BurnDrvStrkfgtr,		// Strike Fighter (Japan)
	&BurnDrvSjryuko1,		// Sukeban Jansi Ryuko (set 1, System 16A, FD1089B 317-5021)
	&BurnDrvSjryuko,		// Sukeban Jansi Ryuko (set 2, System 16B, FD1089B 317-5021)
#if defined FBA_DEBUG
	&BurnDrvShangonro,		// Super Hang-On (Japan, FD1094 317-0038)
	&BurnDrvShangonrb,		// Super Hang-On (bootleg)
#endif
	&BurnDrvShangon2,		// Super Hang-On (mini ride-on, Rev A, FD1089B 317-0034)
	&BurnDrvShangon3,		// Super Hang-On (sitdown/upright, FD1089B 317-0034)
	&BurnDrvShangon,		// Super Hang-On (sitdown/upright, unprotected)
	&BurnDrvSuprleag,		// Super League (FD1094 317-0045)
	&BurnDrvSmgpja,			// Super Monaco GP (Japan, Rev A, FD1094 317-0124a)
	&BurnDrvSmgpj,			// Super Monaco GP (Japan, Rev B, FD1094 317-0124a)
	&BurnDrvSmgpu2,			// Super Monaco GP (US, Rev A, FD1094 317-0125a)
	&BurnDrvSmgpu1,			// Super Monaco GP (US, Rev B, FD1094 317-0125a)
	&BurnDrvSmgpu,			// Super Monaco GP (US, Rev C, FD1094 317-0125a)
	&BurnDrvSmgp5,			// Super Monaco GP (World, 'Air Drive Cabinet', FD1094 317-0126)
	&BurnDrvSmgp6,			// Super Monaco GP (World, Rev A, FD1094 317-0126a)
	&BurnDrvSmgp,			// Super Monaco GP (World, Rev B, 'Twin', FD1094 317-0126a)
	&BurnDrvSmgpu3,			// Super Monaco GP (set 3, US, FD1094 317-0125a)
	&BurnDrvTetrisbl,		// Tetris (bootleg)
	&BurnDrvTetris1,		// Tetris (set 1, Japan, System 16B, FD1094 317-0091)
	&BurnDrvTetris2,		// Tetris (set 2, Japan, System 16B, FD1094 317-0092)
	&BurnDrvTetris3,		// Tetris (set 3, Japan, System 16A, FD1094 317-0093a)
	&BurnDrvTetris,			// Tetris (set 4, Japan, System 16A, FD1094 317-0093)
	&BurnDrvTetrbx,			// Tetris / Bloxeed (Korean System 16 bootleg) (ISG Selection Master Type 2006)
	&BurnDrvThndrbld1,		// Thunder Blade (deluxe/standing, unprotected)
	&BurnDrvThndrbld,		// Thunder Blade (upright, FD1094 317-0056)
	&BurnDrvTimescan1,		// Time Scanner (set 1, System 16A, FD1089B 317-0024)
	&BurnDrvTimescan,		// Time Scanner (set 2, System 16B)
	&BurnDrvToryumon,		// Toryumon
	&BurnDrvTturfu,			// Tough Turf (set 1, US, 8751 317-0099)
	&BurnDrvTturf,			// Tough Turf (set 2, Japan, 8751 317-0104)
	&BurnDrvToutrun,		// Turbo Out Run (Out Run upgrade, FD1094 317-0118)
#if defined FBA_DEBUG
	&BurnDrvToutrun2,		// Turbo Out Run (cockpit, FD1094 317-unknown)
#endif
	&BurnDrvToutrun1,		// Turbo Out Run (deluxe cockpit, FD1094 317-0109)
	&BurnDrvToutrun3,		// Turbo Out Run (upright, FD1094 317-unknown)
	&BurnDrvWwallyja,		// Wally wo Sagase! (rev A, Japan, FD1094 317-0197A)
	&BurnDrvWwallyj,		// Wally wo Sagase! (rev B, Japan, FD1094 317-0197B)
#if defined FBA_DEBUG
	&BurnDrvWb3bbl,			// Wonder Boy III - Monster Lair (bootleg)
#endif
	&BurnDrvWb31,			// Wonder Boy III - Monster Lair (set 1, System 16A, FD1094 317-0084)
	&BurnDrvWb32,			// Wonder Boy III - Monster Lair (set 2, Japan, System 16B, FD1094 317-0085)
	&BurnDrvWb33,			// Wonder Boy III - Monster Lair (set 3, World, System 16B, FD1094 317-0089)
	&BurnDrvWb34,			// Wonder Boy III - Monster Lair (set 4, Japan, System 16B, FD1094 317-0087)
	&BurnDrvWb3,			// Wonder Boy III - Monster Lair (set 5, World, System 16B, 8751 317-0098)
	&BurnDrvWrestwar1,		// Wrestle War (set 1, Japan, FD1094 317-0090)
	&BurnDrvWrestwar2,		// Wrestle War (set 2, World, FD1094 317-0102)
	&BurnDrvWrestwar,		// Wrestle War (set 3, World, 8751 317-0103)
};

